///////////////////////////////////////////////////////////

function SlideCameraTo(end_x, end_y, relative)
{
  var camera_person = "";
  if (IsCameraAttached()) {
    camera_person = GetCameraPerson();
  }

  var start_x = GetCameraX();
  var start_y = GetCameraY();

  if (relative) {
    end_x = start_x + end_x;
    end_y = start_y + end_y;
  }

  CameraSlide(start_x, start_y, end_x, end_y, 1000);

  if (camera_person != "") {
    AttachCamera(camera_person);
  }
}

///////////////////////////////////////////////////////////

function CameraSlide(sx, sy, ex, ey, time)
{
  var camera_person = "";
  if (IsCameraAttached()) {
    camera_person = GetCameraPerson();
  }

  var old_x = GetCameraX();
  var old_y = GetCameraY();

  SetCameraX(sx);
  SetCameraY(sy);

  var x_diff = ex - sx;
  var y_diff = ey - sy;
  
  var start = GetTime();
  while (start + time > GetTime()) {
    var time_passed = GetTime() - start;

    var x_offset = (time ? time_passed / time : 0) * x_diff;
    var y_offset = (time ? time_passed / time : 0) * y_diff;
    
    SetCameraX(sx + x_offset);
    SetCameraY(sy + y_offset);
    
    RenderMap();
    UpdateMapEngine();    
    FlipScreen();
  }
  
  SetCameraX(ex);
  SetCameraY(ey);

  if (camera_person != "") {
    AttachCamera(camera_person);
  }
}

///////////////////////////////////////////////////////////